/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.pi.PIHSCIOCIMClient;
import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PIHSLOptiDataBean;
import com.ibm.hsc.client.PIIOPoolDataBean;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PIProcessorPoolDataBean;
import com.ibm.hsc.client.PITaggedIODataBean;
import com.ibm.hsc.client.PIVirtualEthernetDataBean;
import com.ibm.hsc.client.PIVirtualOptiDataBean;
import com.ibm.hsc.client.PIVirtualSCSIDataBean;
import com.ibm.hsc.client.PIVirtualSerialDataBean;
import com.ibm.hsc.client.PIVirtualSlotDataBean;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.command.PISystemConfigurationCreate;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PIHardwareResourcesList {
    private static final int NUM_VALID_PARMS = 12;
    private String m_managedSystem;
    private String m_resourceType;
    private String m_resourceSubType;
    private String m_format;
    private boolean m_header;
    private String m_filter;
    private String m_level;
    private String m_maxMem;
    private String m_procUnits;
    private String m_recovery;
    private HashMap m_validParms = new HashMap(25, 0.5f);
    private static final String SUBTYPE_VIRT_OPTI = "virtualopti";
    private static final String SUBTYPE_HSL_OPTI = "hsl";
    private static final String FILTER_UNIT = "units";
    private static final String FILTER_BUS = "buses";
    private static final String FILTER_SLOT = "slots";
    private static final String FILTER_POOL = "pools";
    private static final String FILTER_VLAN = "vlans";
    private static final String FILTER_LPAR_ID = "lpar_ids";
    private static final String FILTER_LPAR_NAME = "lpar_names";
    private static final String LEVEL_SYSTEM = "sys";
    private static final String LEVEL_PARTITION = "lpar";
    private static final String LEVEL_SLOT = "slot";
    private static final String LEVEL_OPENSS = "openserial";
    private static final String LEVEL_POOL = "pool";
    private HashMap m_filterHash = new HashMap();
    private PIHSCCECClient m_CECClient = null;
    private Vector m_LPARClient = new Vector();
    private PIHSCIOCIMClient m_IOClient = null;
    private String m_delimiter = ",";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PIHardwareResourcesList(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("--rsubtype", null);
        this.m_validParms.put("--filter", null);
        this.m_validParms.put("--level", null);
        this.m_validParms.put("--maxmem", null);
        this.m_validParms.put("--procunits", null);
        this.m_validParms.put("-R", null);
        this.m_validParms.put("-p", null);
        this.m_validParms.put("--all", null);
    }

    private void doUnitListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"unit_phys_loc"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = this.m_IOClient.getIODrawerDataBeans();
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doBusListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"unit_phys_loc", "bus_id", "backplane_phys_loc", "bus_drc_index", "bus_drc_name"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = this.m_IOClient.getIOBusDataBeans();
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doSlotListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"unit_phys_loc", "bus_id", "phys_loc", "drc_index", "lpar_name", "lpar_id", "slot_io_pool_id", "description", "feature_codes", "pci_vendor_id", "pci_device_id", "pci_subs_vendor_id", "pci_subs_device_id", "pci_class", "pci_revision_id", "bus_grouping", "iop", "iop_info_stale", "console_capable", "load_source_capable", "load_source_attached", "alt_restart_device_capable", "alt_restart_device_attached", "op_console_capable", "op_console_attached", "twinax_capable", "twinax_attached", "direct_console_capable", "lan_console_capable", "vpd_stale", "vpd_type", "vpd_model", "vpd_serial_num", "parent_slot_drc_index", "drc_name"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector vector = this.m_IOClient.getIOSlotDataBeans();
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doRecoverSlotListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"lpar_id", "drc_index"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<String> vector = new Vector<String>(this.m_LPARClient.size());
        for (int i = 0; i < this.m_LPARClient.size(); ++i) {
            PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
            vector.addElement(pIHSCLPARClient.getIntName());
        }
        Vector vector2 = this.m_CECClient.getRecoverableIOSlots(vector);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doIOPoolListOperation() throws PIHscClientException {
        if (LEVEL_SYSTEM.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray2 = new String[]{"max_io_pools"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(stringArray);
            Vector<PICECDataBean> vector = new Vector<PICECDataBean>();
            vector.addElement(pICECDataBean);
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else {
            String[] stringArray;
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PIIOPoolDataBean.ALL_KEYS, PIIOPoolDataBean.ALL_KEYS.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(PIIOPoolDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
            } else {
                stringArray = PIIOPoolDataBean.ALL_KEYS;
            }
            Vector vector = this.m_IOClient.getIOPoolDataBeans();
            if (vector == null) {
                vector = new Vector();
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        }
    }

    private void doTaggedIOListOperation() throws PIHscClientException {
        String[] stringArray;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PITaggedIODataBean.ALL_KEYS, PITaggedIODataBean.ALL_KEYS.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(PITaggedIODataBean.ALL_KEYS, this.m_format, this.m_delimiter);
        } else {
            stringArray = PITaggedIODataBean.ALL_KEYS;
        }
        Vector<PITaggedIODataBean> vector = new Vector<PITaggedIODataBean>();
        for (int i = 0; i < this.m_LPARClient.size(); ++i) {
            PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
            PILPARDataBean pILPARDataBean = pIHSCLPARClient.getLPARDataBean(new String[]{"resource_config"});
            if (!pILPARDataBean.isOS400()) continue;
            PITaggedIODataBean pITaggedIODataBean = pIHSCLPARClient.getTaggedIOs();
            vector.add(pITaggedIODataBean);
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doCPUListOperation() throws PIHscClientException {
        String[] stringArray = null;
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"os400_capable", "assign_5250_cpw_percent", "max_os400_proc_units"});
        if (!pICECDataBean.isInteractiveHMCManaged() && this.m_procUnits != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", new String[]{"--procunits"}, null);
        }
        if (LEVEL_SYSTEM.equals(this.m_level)) {
            UnsignedInt32 unsignedInt32;
            String[] stringArray2;
            stringArray = pICECDataBean.isInteractiveHMCManaged() ? (this.m_procUnits != null ? (pICECDataBean.isOS400ProcCapacityLimited() ? new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "max_os400_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools", "curr_avail_5250_cpw_percent", "pend_avail_5250_cpw_percent", "min_optimal_5250_cpw_percent", "max_optimal_5250_cpw_percent"} : new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools", "curr_avail_5250_cpw_percent", "pend_avail_5250_cpw_percent", "min_optimal_5250_cpw_percent", "max_optimal_5250_cpw_percent"}) : (pICECDataBean.isOS400ProcCapacityLimited() ? new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "max_os400_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools", "curr_avail_5250_cpw_percent", "pend_avail_5250_cpw_percent"} : new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools", "curr_avail_5250_cpw_percent", "pend_avail_5250_cpw_percent"})) : (pICECDataBean.isOS400ProcCapacityLimited() ? new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "max_os400_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools"} : new String[]{"configurable_sys_proc_units", "curr_avail_sys_proc_units", "pend_avail_sys_proc_units", "installed_sys_proc_units", "deconfig_sys_proc_units", "min_proc_units_per_virtual_proc", "max_virtual_procs_per_lpar", "max_shared_proc_pools"});
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray, stringArray.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray2 = PICmdOutputUtils.checkKeys(stringArray, this.m_format, this.m_delimiter);
            } else {
                stringArray2 = stringArray;
            }
            PICECDataBean pICECDataBean2 = this.m_CECClient.getCECDataBean(stringArray2);
            if (this.m_procUnits != null) {
                unsignedInt32 = null;
                try {
                    unsignedInt32 = new UnsignedInt32(PIHMCCommandUtils.decodeTwoDigitPrecisionValue(this.m_procUnits));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", new String[]{"--procunits"}, null);
                }
                UnsignedInt16[] unsignedInt16Array = this.m_CECClient.queryOptimalInteractiveRange(unsignedInt32);
                pICECDataBean2.setMinInteractiveProc(unsignedInt16Array[0]);
                pICECDataBean2.setMaxInteractiveProc(unsignedInt16Array[1]);
            }
            unsignedInt32 = new Vector();
            unsignedInt32.addElement(pICECDataBean2);
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, unsignedInt32.elements(), stringArray2, this.m_delimiter, this.m_header, this.m_format == null);
        } else if (LEVEL_PARTITION.equals(this.m_level)) {
            String[] stringArray3;
            stringArray = pICECDataBean.isInteractiveHMCManaged() ? new String[]{"lpar_name", "lpar_id", "curr_shared_proc_pool_id", "curr_proc_mode", "curr_min_proc_units", "curr_proc_units", "curr_max_proc_units", "curr_min_procs", "curr_procs", "curr_max_procs", "curr_sharing_mode", "curr_uncap_weight", "curr_min_5250_cpw_percent", "curr_5250_cpw_percent", "curr_max_5250_cpw_percent", "pend_shared_proc_pool_id", "pend_proc_mode", "pend_min_proc_units", "pend_proc_units", "pend_max_proc_units", "pend_min_procs", "pend_procs", "pend_max_procs", "pend_sharing_mode", "pend_uncap_weight", "pend_min_5250_cpw_percent", "pend_5250_cpw_percent", "pend_max_5250_cpw_percent", "run_proc_units", "run_procs", "run_uncap_weight", "run_5250_cpw_percent", "resource_config"} : new String[]{"lpar_name", "lpar_id", "curr_shared_proc_pool_id", "curr_proc_mode", "curr_min_proc_units", "curr_proc_units", "curr_max_proc_units", "curr_min_procs", "curr_procs", "curr_max_procs", "curr_sharing_mode", "curr_uncap_weight", "pend_shared_proc_pool_id", "pend_proc_mode", "pend_min_proc_units", "pend_proc_units", "pend_max_proc_units", "pend_min_procs", "pend_procs", "pend_max_procs", "pend_sharing_mode", "pend_uncap_weight", "run_proc_units", "run_procs", "run_uncap_weight", "resource_config"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray, stringArray.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray3 = PICmdOutputUtils.checkKeys(stringArray, this.m_format, this.m_delimiter);
            } else {
                stringArray3 = stringArray;
            }
            Vector<PILPARDataBean> vector = new Vector<PILPARDataBean>(this.m_LPARClient.size());
            for (int i = 0; i < this.m_LPARClient.size(); ++i) {
                PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
                vector.addElement(pIHSCLPARClient.getLPARDataBean(stringArray3));
            }
            if (this.m_format == null || this.m_format.length() == 0) {
                stringArray3[stringArray3.length - 1] = "";
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray3, this.m_delimiter, this.m_header, this.m_format == null);
        } else if (LEVEL_POOL.equals(this.m_level)) {
            String[] stringArray4;
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, PIProcessorPoolDataBean.ALL_KEYS, PIProcessorPoolDataBean.ALL_KEYS.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray4 = PICmdOutputUtils.checkKeys(PIProcessorPoolDataBean.ALL_KEYS, this.m_format, this.m_delimiter);
            } else {
                stringArray4 = PIProcessorPoolDataBean.ALL_KEYS;
            }
            PICECDataBean pICECDataBean3 = this.m_CECClient.getCECDataBean(new String[]{"proc_pools"});
            Hashtable hashtable = pICECDataBean3.getProcessorPools();
            if (hashtable != null) {
                PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, hashtable.elements(), stringArray4, this.m_delimiter, this.m_header, this.m_format == null);
            }
        }
    }

    private void doRecoverCPUListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"pend_procs", "run_procs", "lpar_id", "lpar_name"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<String> vector = new Vector<String>(this.m_LPARClient.size());
        for (int i = 0; i < this.m_LPARClient.size(); ++i) {
            PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
            vector.addElement(pIHSCLPARClient.getIntName());
        }
        Vector vector2 = this.m_CECClient.getRecoverableCPU(vector);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doMemListOperation() throws PIHscClientException {
        if (LEVEL_SYSTEM.equals(this.m_level)) {
            UnsignedInt32 unsignedInt32;
            String[] stringArray;
            String[] stringArray2 = null;
            stringArray2 = this.m_maxMem == null ? new String[]{"configurable_sys_mem", "curr_avail_sys_mem", "pend_avail_sys_mem", "installed_sys_mem", "deconfig_sys_mem", "sys_firmware_mem", "mem_region_size"} : new String[]{"configurable_sys_mem", "curr_avail_sys_mem", "pend_avail_sys_mem", "installed_sys_mem", "deconfig_sys_mem", "sys_firmware_mem", "mem_region_size", "required_min_mem_aix_linux", "required_min_mem_os400", "required_min_mem_mm"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(stringArray);
            if (this.m_maxMem != null) {
                long l;
                long l2;
                unsignedInt32 = null;
                try {
                    unsignedInt32 = new UnsignedInt32(this.m_maxMem);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", new String[]{"--maxmem"}, null);
                }
                UnsignedInt16 unsignedInt16 = pICECDataBean.getMemoryRegionSize();
                if (unsignedInt16 == null) {
                    PICECDataBean pICECDataBean2 = this.m_CECClient.getCECDataBean(new String[]{"mem_region_size"});
                    unsignedInt16 = pICECDataBean2.getMemoryRegionSize();
                }
                if ((l2 = unsignedInt32.longValue()) % (l = unsignedInt16.longValue()) != 0L) {
                    String[] stringArray3 = new String[]{"--maxmem"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_MEM_PARM_VALUE_NOT_MULTIPLE", stringArray3, null);
                }
                UnsignedInt32 unsignedInt322 = new UnsignedInt32(l2 / l);
                pICECDataBean.setReqMinMemRPA(this.m_CECClient.queryRequiredMinMemoryForMax(new UnsignedInt8(1), unsignedInt322));
                pICECDataBean.setReqMinMemOS400(this.m_CECClient.queryRequiredMinMemoryForMax(new UnsignedInt8(3), unsignedInt322));
                pICECDataBean.setReqMinMemMM(this.m_CECClient.queryRequiredMinMemoryForMax(new UnsignedInt8(2), unsignedInt322));
            }
            unsignedInt32 = new Vector();
            unsignedInt32.addElement(pICECDataBean);
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, unsignedInt32.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else if (LEVEL_PARTITION.equals(this.m_level)) {
            String[] stringArray;
            Object object;
            int n;
            String[] stringArray4 = new String[]{"lpar_name", "lpar_id", "curr_min_mem", "curr_mem", "curr_max_mem", "pend_min_mem", "pend_mem", "pend_max_mem", "run_min_mem", "run_mem"};
            String[] stringArray5 = new String[]{"mm_curr_reserve1_max_mem", "mm_curr_reserve1_mem", "mm_curr_reserve1_min_mem", "mm_curr_reserve2_max_mem", "mm_curr_reserve2_mem", "mm_curr_reserve2_min_mem", "mm_pend_reserve1_max_mem", "mm_pend_reserve1_mem", "mm_pend_reserve1_min_mem", "mm_pend_reserve2_max_mem", "mm_pend_reserve2_mem", "mm_pend_reserve2_min_mem"};
            if (this.m_format != null && this.m_format.length() > 0) {
                int n2 = stringArray4.length;
                n = stringArray5.length;
                object = new String[n2 + n];
                System.arraycopy(stringArray4, 0, object, 0, n2);
                System.arraycopy(stringArray5, 0, object, n2, n);
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, (String[])object, ((Object)object).length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys((String[])object, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray4;
            }
            Vector<PILPARDataBean> vector = new Vector<PILPARDataBean>(this.m_LPARClient.size());
            for (n = 0; n < this.m_LPARClient.size(); ++n) {
                object = (PIHSCLPARClient)this.m_LPARClient.elementAt(n);
                vector.addElement(object.getLPARDataBean(stringArray));
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        }
    }

    private void doRecoverMemListOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = new String[]{"pend_mem", "run_mem", "lpar_id", "lpar_name"};
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        Vector<String> vector = new Vector<String>(this.m_LPARClient.size());
        for (int i = 0; i < this.m_LPARClient.size(); ++i) {
            PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
            vector.addElement(pIHSCLPARClient.getIntName());
        }
        Vector vector2 = this.m_CECClient.getRecoverableMemory(vector);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector2.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doVirtualOptiConnectOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = PIVirtualOptiDataBean.ALL_KEYS;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_POOL);
        Enumeration enumeration = this.m_CECClient.getVirtualOptiDataBean(stringArray3, this.m_LPARClient);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, enumeration, stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doHSLOptiConnectOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = PIHSLOptiDataBean.ALL_KEYS;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_POOL);
        Enumeration enumeration = this.m_CECClient.getHSLOptiDataBean(stringArray3, this.m_LPARClient);
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, enumeration, stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    private void doVirtualEthernetOperation() throws PIHscClientException {
        if (LEVEL_SYSTEM.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray2 = new String[]{"max_vlans_per_port", "mac_prefix"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(stringArray);
            Vector<PICECDataBean> vector = new Vector<PICECDataBean>();
            vector.addElement(pICECDataBean);
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else if (LEVEL_PARTITION.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray3 = PIVirtualEthernetDataBean.ALL_KEYS;
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray3, stringArray3.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray3, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray3;
            }
            String[] stringArray4 = (String[])this.m_filterHash.get(FILTER_SLOT);
            String[] stringArray5 = (String[])this.m_filterHash.get(FILTER_VLAN);
            Vector<PIVirtualEthernetDataBean> vector = new Vector<PIVirtualEthernetDataBean>();
            Iterator iterator = this.m_LPARClient.iterator();
            while (iterator.hasNext()) {
                PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)iterator.next();
                Enumeration enumeration = pIHSCLPARClient.getVirtualEthernetDataBeans(stringArray);
                while (enumeration.hasMoreElements()) {
                    boolean bl = false;
                    PIVirtualEthernetDataBean pIVirtualEthernetDataBean = (PIVirtualEthernetDataBean)enumeration.nextElement();
                    if (stringArray4 != null && stringArray4.length > 0) {
                        for (int i = 0; i < stringArray4.length; ++i) {
                            if (pIVirtualEthernetDataBean.getSlotNumber().intValue() != Integer.parseInt(stringArray4[i])) continue;
                            bl = true;
                            break;
                        }
                    } else {
                        bl = true;
                    }
                    if (bl && stringArray5 != null && stringArray5.length > 0) {
                        int n;
                        UnsignedInt16[] unsignedInt16Array;
                        Vector<String> vector2 = new Vector<String>();
                        UnsignedInt16 unsignedInt16 = pIVirtualEthernetDataBean.getPvid();
                        if (unsignedInt16 != null) {
                            vector2.add(unsignedInt16.toString());
                        }
                        if ((unsignedInt16Array = pIVirtualEthernetDataBean.getAdditionalVids()) != null) {
                            for (n = 0; n < unsignedInt16Array.length; ++n) {
                                if (unsignedInt16Array[n] == null) continue;
                                vector2.add(unsignedInt16Array[n].toString());
                            }
                        }
                        n = 0;
                        for (int i = 0; i < stringArray5.length; ++i) {
                            if (!vector2.contains(stringArray5[i])) continue;
                            n = 1;
                            break;
                        }
                        if (n == 0) {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    vector.addElement(pIVirtualEthernetDataBean);
                }
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        }
    }

    public void doVirtualSCSIOperation() throws PIHscClientException {
        String[] stringArray;
        String[] stringArray2 = PIVirtualSCSIDataBean.ALL_KEYS;
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
        } else {
            stringArray = stringArray2;
        }
        String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_SLOT);
        Vector<PIVirtualSCSIDataBean> vector = new Vector<PIVirtualSCSIDataBean>();
        Iterator iterator = this.m_LPARClient.iterator();
        while (iterator.hasNext()) {
            PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)iterator.next();
            Iterator iterator2 = pIHSCLPARClient.getVirtualSCSIDataBeans(stringArray3);
            while (iterator2.hasNext()) {
                PIVirtualSCSIDataBean pIVirtualSCSIDataBean = (PIVirtualSCSIDataBean)iterator2.next();
                vector.addElement(pIVirtualSCSIDataBean);
            }
        }
        PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
    }

    public void doVirtualSerialOperation() throws PIHscClientException {
        if (LEVEL_PARTITION.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray2 = PIVirtualSerialDataBean.ALL_KEYS;
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_SLOT);
            Vector<PIVirtualSerialDataBean> vector = new Vector<PIVirtualSerialDataBean>();
            Iterator iterator = this.m_LPARClient.iterator();
            while (iterator.hasNext()) {
                PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)iterator.next();
                Iterator iterator2 = pIHSCLPARClient.getVirtualSerialDataBeans(stringArray3);
                while (iterator2.hasNext()) {
                    PIVirtualSerialDataBean pIVirtualSerialDataBean = (PIVirtualSerialDataBean)iterator2.next();
                    vector.addElement(pIVirtualSerialDataBean);
                }
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else {
            if (this.m_writeStatus) {
                this.m_writeStatus = false;
                this.m_out.print('\u0000');
            }
            this.m_out.println("lshwres -r virtualio --rsubtype serial --level openserial not implemented yet.");
        }
    }

    private void doVirtualSlotOperation() throws PIHscClientException {
        if (LEVEL_SLOT.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray2 = new String[]{"slot_num", "lpar_name", "lpar_id", "config", "state", "drc_name"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray2, stringArray2.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray2, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray2;
            }
            String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_SLOT);
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = this.m_LPARClient.iterator();
            while (iterator.hasNext()) {
                Object object;
                PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)iterator.next();
                Enumeration enumeration = pIHSCLPARClient.getVirtualEthernetDataBeans(stringArray);
                block1: while (enumeration.hasMoreElements()) {
                    object = (PIVirtualEthernetDataBean)enumeration.nextElement();
                    if (stringArray3 != null && stringArray3.length > 0) {
                        for (int i = 0; i < stringArray3.length; ++i) {
                            if (((PIVirtualSlotDataBean)object).getSlotNumber().intValue() != Integer.parseInt(stringArray3[i])) continue;
                            vector.addElement(object);
                            continue block1;
                        }
                        continue;
                    }
                    vector.addElement(object);
                }
                object = pIHSCLPARClient.getVirtualSCSIDataBeans(stringArray3);
                while (object.hasNext()) {
                    vector.addElement((PIVirtualSCSIDataBean)object.next());
                }
                Iterator iterator2 = pIHSCLPARClient.getVirtualSerialDataBeans(stringArray3);
                while (iterator2.hasNext()) {
                    vector.addElement((PIVirtualSerialDataBean)iterator2.next());
                }
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else if (LEVEL_PARTITION.equals(this.m_level)) {
            String[] stringArray;
            String[] stringArray4 = new String[]{"lpar_name", "lpar_id", "curr_max_virtual_slots", "pend_max_virtual_slots"};
            if (this.m_format != null && this.m_format.length() > 0) {
                this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, stringArray4, stringArray4.length);
                if (this.m_delimiter.length() == 0) {
                    this.m_delimiter = ",";
                }
                stringArray = PICmdOutputUtils.checkKeys(stringArray4, this.m_format, this.m_delimiter);
            } else {
                stringArray = stringArray4;
            }
            Vector<PILPARDataBean> vector = new Vector<PILPARDataBean>();
            for (int i = 0; i < this.m_LPARClient.size(); ++i) {
                PIHSCLPARClient pIHSCLPARClient = (PIHSCLPARClient)this.m_LPARClient.elementAt(i);
                vector.addElement(pIHSCLPARClient.getLPARDataBean(stringArray));
            }
            PICmdOutputUtils.printResults(this.m_out, this.m_writeStatus, vector.elements(), stringArray, this.m_delimiter, this.m_header, this.m_format == null);
        } else {
            if (this.m_writeStatus) {
                this.m_writeStatus = false;
                this.m_out.print('\u0000');
            }
            this.m_out.println("lshwres -r virtualio --rsubtype slot --level slot not implemented yet.");
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType == null || !"proc".equals(this.m_resourceType) && !"mem".equals(this.m_resourceType) && !"virtualio".equals(this.m_resourceType) && !"io".equals(this.m_resourceType)) {
            string = "-r";
        }
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ("io".equals(this.m_resourceType)) {
            if (!("unit".equals(this.m_resourceSubType) || "bus".equals(this.m_resourceSubType) || LEVEL_SLOT.equals(this.m_resourceSubType) || "iopool".equals(this.m_resourceSubType) || "taggedio".equals(this.m_resourceSubType))) {
                String[] stringArray = new String[]{"--rsubtype"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
            if ("iopool".equals(this.m_resourceSubType)) {
                if (this.m_level == null || !LEVEL_SYSTEM.equals(this.m_level) && !LEVEL_POOL.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if (this.m_level != null) {
                String[] stringArray = new String[]{"--level"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM", stringArray, null);
            }
        } else if ("proc".equals(this.m_resourceType)) {
            if (!(LEVEL_SYSTEM.equals(this.m_level) || LEVEL_PARTITION.equals(this.m_level) || LEVEL_POOL.equals(this.m_level))) {
                String[] stringArray = new String[]{"--level"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else if ("mem".equals(this.m_resourceType)) {
            if (!LEVEL_SYSTEM.equals(this.m_level) && !LEVEL_PARTITION.equals(this.m_level)) {
                String[] stringArray = new String[]{"--level"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        } else if ("virtualio".equals(this.m_resourceType)) {
            if (SUBTYPE_VIRT_OPTI.equals(this.m_resourceSubType) || SUBTYPE_HSL_OPTI.equals(this.m_resourceSubType)) {
                if (this.m_level != null && !LEVEL_PARTITION.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if ("eth".equals(this.m_resourceSubType)) {
                if (!LEVEL_PARTITION.equals(this.m_level) && !LEVEL_SYSTEM.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if ("scsi".equals(this.m_resourceSubType)) {
                if (this.m_level != null && !LEVEL_PARTITION.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if ("serial".equals(this.m_resourceSubType)) {
                if (!LEVEL_PARTITION.equals(this.m_level) && !LEVEL_OPENSS.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else if (LEVEL_SLOT.equals(this.m_resourceSubType)) {
                if (!LEVEL_PARTITION.equals(this.m_level) && !LEVEL_SLOT.equals(this.m_level)) {
                    String[] stringArray = new String[]{"--level"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
                }
            } else {
                String[] stringArray = new String[]{"--rsubtype"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        }
        if (this.m_maxMem != null) {
            if (!"mem".equals(this.m_resourceType)) {
                String[] stringArray = new String[]{"--maxmem", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
            if (!LEVEL_SYSTEM.equals(this.m_level)) {
                String[] stringArray = new String[]{"--level"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        }
        if (this.m_procUnits != null) {
            if (!"proc".equals(this.m_resourceType)) {
                String[] stringArray = new String[]{"--procunits", this.m_resourceType};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_FOR_RESOURCE", stringArray, null);
            }
            if (!LEVEL_SYSTEM.equals(this.m_level)) {
                String[] stringArray = new String[]{"--level"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
            }
        }
        if (this.m_filter != null) {
            this.parseFilter(this.m_filter);
        }
        if (this.m_header && this.m_format == null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseFilter(String string) throws PIHscClientException {
        CSVRecord cSVRecord = new CSVRecord(string, true, ",");
        Iterator iterator = cSVRecord.iterator();
        this.m_filterHash = new HashMap(cSVRecord.size() * 2);
        while (iterator.hasNext()) {
            int n;
            String string2 = (String)iterator.next();
            int n2 = string2.indexOf("=");
            if (n2 == -1) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            String[] stringArray = null;
            if (string3.length() == 0 || string4.length() == 0) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER", null, null);
            }
            stringArray = PIHMCCommandUtils.parseList(string4, ",");
            if (FILTER_LPAR_NAME.equals(string3) || FILTER_LPAR_ID.equals(string3)) {
                if (FILTER_LPAR_ID.equals(string3)) {
                    try {
                        for (n = 0; n < stringArray.length; ++n) {
                            PISystemConfigurationCreate.decodeStrValue(stringArray[n]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_VALUE", new String[]{string3}, null);
                    }
                }
                if ("io".equals(this.m_resourceType)) {
                    if (!(LEVEL_SLOT.equals(this.m_resourceSubType) || "iopool".equals(this.m_resourceSubType) || "taggedio".equals(this.m_resourceSubType))) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                    }
                    if ("iopool".equals(this.m_resourceSubType) && !LEVEL_POOL.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_resourceSubType, this.m_level}, null);
                    }
                } else if ("virtualio".equals(this.m_resourceType)) {
                    if ("eth".equals(this.m_resourceSubType) && !LEVEL_PARTITION.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_resourceSubType, this.m_level}, null);
                    }
                } else if ("proc".equals(this.m_resourceType)) {
                    if (!LEVEL_PARTITION.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_level}, null);
                    }
                } else {
                    if (!"mem".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                    if (!LEVEL_PARTITION.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_level}, null);
                    }
                }
            } else if (FILTER_UNIT.equals(string3)) {
                if (!"io".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                if (!("unit".equals(this.m_resourceSubType) || "bus".equals(this.m_resourceSubType) || LEVEL_SLOT.equals(this.m_resourceSubType))) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                }
            } else if (FILTER_BUS.equals(string3)) {
                if (!"io".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                if (!"bus".equals(this.m_resourceSubType) && !LEVEL_SLOT.equals(this.m_resourceSubType)) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                }
            } else if (FILTER_SLOT.equals(string3)) {
                if ("io".equals(this.m_resourceType)) {
                    if (!LEVEL_SLOT.equals(this.m_resourceSubType)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                    }
                    for (n = 0; n < stringArray.length; ++n) {
                        try {
                            long l = Long.parseLong(stringArray[n], 16);
                            stringArray[n] = new Long(l).toString();
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                } else {
                    if (!"virtualio".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                    if ("eth".equals(this.m_resourceSubType) && !LEVEL_PARTITION.equals(this.m_level) || LEVEL_SLOT.equals(this.m_resourceSubType) && !LEVEL_SLOT.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_resourceSubType, this.m_level}, null);
                    }
                    if (SUBTYPE_HSL_OPTI.equals(this.m_resourceSubType) || SUBTYPE_VIRT_OPTI.equals(this.m_resourceSubType)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                    }
                }
            } else if (FILTER_POOL.equals(string3)) {
                try {
                    for (n = 0; n < stringArray.length; ++n) {
                        PISystemConfigurationCreate.decodeStrValue(stringArray[n]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_VALUE", new String[]{string3}, null);
                }
                if ("io".equals(this.m_resourceType)) {
                    if (!"iopool".equals(this.m_resourceSubType) && !LEVEL_SLOT.equals(this.m_resourceSubType)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                    }
                    if ("iopool".equals(this.m_resourceSubType) && !LEVEL_POOL.equals(this.m_level)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_resourceSubType, this.m_level}, null);
                    }
                } else {
                    if (!"virtualio".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                    if (!SUBTYPE_VIRT_OPTI.equals(this.m_resourceSubType) && !SUBTYPE_HSL_OPTI.equals(this.m_resourceSubType)) {
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                    }
                }
            } else {
                if (!FILTER_VLAN.equals(string3)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_NAME", new String[]{string3}, null);
                try {
                    for (n = 0; n < stringArray.length; ++n) {
                        PISystemConfigurationCreate.decodeStrValue(stringArray[n]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_VALUE", new String[]{string3}, null);
                }
                if (!"virtualio".equals(this.m_resourceType)) throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RESOURCE", new String[]{string3, this.m_resourceType}, null);
                if ("eth".equals(this.m_resourceSubType) && !LEVEL_PARTITION.equals(this.m_level)) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE_AND_LEVEL", new String[]{string3, this.m_resourceType, this.m_resourceSubType, this.m_level}, null);
                }
                if (!"eth".equals(this.m_resourceSubType)) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_FOR_RES_AND_SUBTYPE", new String[]{string3, this.m_resourceType, this.m_resourceSubType}, null);
                }
            }
            if (this.m_filterHash.put(string3, stringArray) == null) continue;
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "SAME_FILTER_MULTI_ENTRIES", new String[]{string3}, null);
        }
        if (!this.m_filterHash.containsKey(FILTER_LPAR_ID) || !this.m_filterHash.containsKey(FILTER_LPAR_NAME)) return;
        String[] stringArray = new String[]{"lpar_names, lpar_ids"};
        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_FILTER_NAMES", stringArray, null);
    }

    private void initializeClients() throws PIHscClientException {
        String[] stringArray;
        String string = null;
        Object var2_2 = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string, null);
        Object[] objectArray = null;
        boolean bl = false;
        if (LEVEL_PARTITION.equals(this.m_level) || "io".equals(this.m_resourceType) && "taggedio".equals(this.m_resourceSubType) || "virtualio".equals(this.m_resourceType) && ("scsi".equals(this.m_resourceSubType) || LEVEL_SLOT.equals(this.m_resourceSubType) || SUBTYPE_VIRT_OPTI.equals(this.m_resourceSubType) || SUBTYPE_HSL_OPTI.equals(this.m_resourceSubType))) {
            if (this.m_filterHash.containsKey(FILTER_LPAR_ID)) {
                objectArray = (String[])this.m_filterHash.get(FILTER_LPAR_ID);
                bl = true;
            } else if (this.m_filterHash.containsKey(FILTER_LPAR_NAME)) {
                objectArray = (String[])this.m_filterHash.get(FILTER_LPAR_NAME);
            } else {
                Vector vector = this.m_CECClient.getPartitionNames();
                objectArray = new String[vector.size()];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray = (String[])vector.elementAt(i);
                    objectArray[i] = stringArray[0];
                }
                bl = true;
                Arrays.sort(objectArray);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                PIHSCLPARClient pIHSCLPARClient = null;
                if (bl) {
                    try {
                        pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(this.m_managedSystem, (String)objectArray[i], true);
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        pIHSCLPARClient = pIHSCClientObjectFactory.createLPARClient(this.m_managedSystem, (String)objectArray[i], false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (pIHSCLPARClient != null) {
                    this.m_LPARClient.addElement(pIHSCLPARClient);
                    continue;
                }
                if (!this.m_filterHash.containsKey(FILTER_LPAR_NAME) && !this.m_filterHash.containsKey(FILTER_LPAR_ID)) continue;
                stringArray = new String[]{objectArray[i]};
                if (bl) {
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
                }
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
            }
        }
        if ("io".equals(this.m_resourceType) && ("unit".equals(this.m_resourceSubType) || "bus".equals(this.m_resourceSubType) || LEVEL_SLOT.equals(this.m_resourceSubType) || "iopool".equals(this.m_resourceSubType))) {
            String[] stringArray2 = (String[])this.m_filterHash.get(FILTER_UNIT);
            String[] stringArray3 = (String[])this.m_filterHash.get(FILTER_BUS);
            stringArray = (String[])this.m_filterHash.get(FILTER_SLOT);
            String[] stringArray4 = (String[])this.m_filterHash.get(FILTER_LPAR_ID);
            String[] stringArray5 = (String[])this.m_filterHash.get(FILTER_LPAR_NAME);
            String[] stringArray6 = (String[])this.m_filterHash.get(FILTER_POOL);
            this.m_IOClient = pIHSCClientObjectFactory.createIOClient(this.m_managedSystem, stringArray2, stringArray3, stringArray, stringArray5, stringArray4, stringArray6, false);
            if (null == this.m_IOClient) {
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8002", null, null);
            }
        }
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (n != 17 && n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
        }
        this.initializeClients();
        if (this.m_resourceType.equals("io")) {
            if (this.m_resourceSubType.equals("unit")) {
                this.doUnitListOperation();
            } else if (this.m_resourceSubType.equals("bus")) {
                this.doBusListOperation();
            } else if (this.m_resourceSubType.equals(LEVEL_SLOT)) {
                if (this.m_recovery != null) {
                    this.doRecoverSlotListOperation();
                } else {
                    this.doSlotListOperation();
                }
            } else if (this.m_resourceSubType.equals("iopool")) {
                this.doIOPoolListOperation();
            } else if (this.m_resourceSubType.equals("taggedio")) {
                this.doTaggedIOListOperation();
            }
        } else if (this.m_resourceType.equals("proc")) {
            if (this.m_recovery != null) {
                this.doRecoverCPUListOperation();
            } else {
                this.doCPUListOperation();
            }
        } else if (this.m_resourceType.equals("mem")) {
            if (this.m_recovery != null) {
                this.doRecoverMemListOperation();
            } else {
                this.doMemListOperation();
            }
        } else if (this.m_resourceType.equals("virtualio")) {
            if (this.m_resourceSubType.equals(SUBTYPE_VIRT_OPTI)) {
                this.doVirtualOptiConnectOperation();
            } else if (this.m_resourceSubType.equals(SUBTYPE_HSL_OPTI)) {
                this.doHSLOptiConnectOperation();
            } else if (this.m_resourceSubType.equals("eth")) {
                this.doVirtualEthernetOperation();
            } else if (this.m_resourceSubType.equals("scsi")) {
                this.doVirtualSCSIOperation();
            } else if (this.m_resourceSubType.equals("serial")) {
                this.doVirtualSerialOperation();
            } else if (this.m_resourceSubType.equals(LEVEL_SLOT)) {
                this.doVirtualSlotOperation();
            }
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_format = (String)hashMap.get("-F");
        String string = (String)hashMap.get("--header");
        this.m_header = string != null;
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_resourceSubType = (String)hashMap.get("--rsubtype");
        this.m_filter = (String)hashMap.get("--filter");
        this.m_level = (String)hashMap.get("--level");
        this.m_maxMem = (String)hashMap.get("--maxmem");
        this.m_recovery = (String)hashMap.get("-R");
        this.m_procUnits = (String)hashMap.get("--procunits");
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        if ("led".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSHWRES_LED_TYPE", null, null);
        }
        if (LEVEL_SLOT.equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSHWRES_SLOT_TYPE", null, null);
        }
        if ("cpu".equals(this.m_resourceType)) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSHWRES_CPU_TYPE", null, null);
        }
        String string = (String)hashMap.get("-p");
        if (string != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSHWRES_P_PARM", null, null);
        }
        String string2 = (String)hashMap.get("--all");
        if (string2 != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_LSHWRES_ALL_PARM", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSHWRES_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PIHardwareResourcesList pIHardwareResourcesList = new PIHardwareResourcesList(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pIHardwareResourcesList.m_validParms);
            pIHardwareResourcesList.mapParameters(hashMap);
            pIHardwareResourcesList.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

